/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.query.VWDateTimeErrDialog;
import filenet.vw.toolkit.utils.query.VWFieldListRenderer;
import filenet.vw.toolkit.utils.query.VWIndexListRenderer;
import filenet.vw.toolkit.utils.query.VWOperatorComboBoxRenderer;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWInfoLabel;
import filenet.vw.toolkit.utils.uicontrols.border.VWLineBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

class VWWorkBasketQueueQueryPanel
extends JPanel
implements ActionListener,
FocusListener,
IVWWizardPanel {
    private VWSessionInfo m_sessionInfo = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private VWQueueDefinition m_queueDef = null;
    private boolean m_bIsModified = false;
    private Color m_enabledBkgrndColor = SystemColor.text;
    private boolean m_bDisplayIndexControls = true;
    private JRadioButton m_AllContentRadioButton = null;
    private JRadioButton m_useFilterRadioButton = null;
    private JPanel m_filterPanel = null;
    private JPanel m_spacerPanel = null;
    private JCheckBox m_showAllUserCheckBox = null;
    private JToggleButton m_leftParenButton = null;
    private JToggleButton m_rightParenButton = null;
    private JComboBox m_fieldsCombo = null;
    private JComboBox m_operatorsCombo = null;
    private JTextField m_valueTextField = null;
    private JComboBox m_logicalOpsCombo = null;
    private JButton m_insertButton = null;
    private JButton m_clearButton = null;
    private JTextArea m_filterStringTextArea = null;
    private JComboBox m_indexCombo = null;

    public VWWorkBasketQueueQueryPanel(VWSessionInfo sessionInfo, boolean bDisplayIndexControls) {
        this.m_sessionInfo = sessionInfo;
        this.m_bDisplayIndexControls = bDisplayIndexControls;
        this.createControls();
    }

    public void setEnabled(boolean bEnable) {
        this.m_AllContentRadioButton.setEnabled(bEnable);
        this.m_useFilterRadioButton.setEnabled(bEnable);
        this.m_showAllUserCheckBox.setEnabled(bEnable);
        this.m_leftParenButton.setEnabled(bEnable);
        this.m_rightParenButton.setEnabled(bEnable);
        this.m_fieldsCombo.setEnabled(bEnable);
        this.m_operatorsCombo.setEnabled(bEnable);
        this.m_valueTextField.setEnabled(bEnable);
        this.m_logicalOpsCombo.setEnabled(bEnable);
        this.m_insertButton.setEnabled(bEnable);
        this.m_clearButton.setEnabled(bEnable);
        this.m_filterStringTextArea.setEnabled(bEnable);
        if (this.m_indexCombo != null) {
            this.m_indexCombo.setEnabled(bEnable);
        }
        this.m_filterPanel.setVisible(bEnable);
        this.m_spacerPanel.setVisible(!bEnable);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_AllContentRadioButton)) {
            try {
                this.m_workBasketDef.setQueryFilterString(null);
                this.m_workBasketDef.setIndexName(null);
                this.initFilterStringTextArea();
                this.initSelectedIndex();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_filterPanel.setVisible(false);
            this.m_spacerPanel.setVisible(true);
        } else if (source.equals(this.m_useFilterRadioButton)) {
            try {
                this.initFilterStringTextArea();
                this.initSelectedIndex();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            this.m_filterPanel.setVisible(true);
            this.m_spacerPanel.setVisible(false);
        } else if (source.equals(this.m_showAllUserCheckBox)) {
            try {
                this.m_workBasketDef.setShowWorkForAllUsers(this.m_showAllUserCheckBox.isSelected());
            }
            catch (VWException ex) {
                ex.printStackTrace();
            }
        } else if (source.equals(this.m_fieldsCombo)) {
            this.initOperatorsCombo();
            if (this.m_valueTextField != null) {
                this.m_valueTextField.setText("");
                this.m_valueTextField.setEnabled(true);
                this.m_valueTextField.setBackground(this.m_enabledBkgrndColor);
            }
        } else if (source.equals(this.m_operatorsCombo)) {
            Integer item;
            if (this.m_operatorsCombo != null && (item = (Integer)this.m_operatorsCombo.getSelectedItem()) != null) {
                int op = (Integer)this.m_operatorsCombo.getSelectedItem();
                if (op == 8 || op == 9) {
                    this.m_valueTextField.setText("");
                    this.m_valueTextField.setEnabled(false);
                    this.m_valueTextField.setBackground(this.getBackground());
                } else {
                    this.m_valueTextField.setEnabled(true);
                    this.m_valueTextField.setBackground(this.m_enabledBkgrndColor);
                }
            }
        } else if (source.equals(this.m_insertButton) || source.equals(this.m_valueTextField)) {
            this.updateFilterString();
            this.handleUpdateEvent(event.getSource());
            this.m_leftParenButton.setSelected(false);
            this.m_rightParenButton.setSelected(false);
        } else if (source.equals(this.m_indexCombo)) {
            this.handleUpdateEvent(event.getSource());
        } else if (source.equals(this.m_clearButton)) {
            this.resetFilterControls();
            this.handleUpdateEvent(this.m_filterStringTextArea);
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        if (this.m_workBasketDef == null) {
            return;
        }
        this.handleUpdateEvent(event.getSource());
    }

    public void checkForErrors() throws Exception {
    }

    public String getHelpTopic() {
        return "query_definition";
    }

    public String getUniqueIdentifier() {
        return "QUERY_DEFINITION";
    }

    public String getInstructions() {
        return VWResource.QueryDefinitionPanelInstructions;
    }

    public String getTitle() {
        return VWResource.QueryDefinitionPanelTitle;
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        if (this.m_AllContentRadioButton != null) {
            this.m_AllContentRadioButton.removeActionListener(this);
            this.m_AllContentRadioButton = null;
        }
        if (this.m_useFilterRadioButton != null) {
            this.m_useFilterRadioButton.removeActionListener(this);
            this.m_useFilterRadioButton = null;
        }
        if (this.m_showAllUserCheckBox != null) {
            this.m_showAllUserCheckBox.removeActionListener(this);
            this.m_showAllUserCheckBox = null;
        }
        this.m_leftParenButton = null;
        this.m_rightParenButton = null;
        if (this.m_fieldsCombo != null) {
            if (this.m_fieldsCombo.getItemCount() > 0) {
                this.m_fieldsCombo.removeAllItems();
            }
            this.m_fieldsCombo.removeActionListener(this);
            this.m_fieldsCombo = null;
        }
        if (this.m_operatorsCombo != null) {
            if (this.m_operatorsCombo.getItemCount() > 0) {
                this.m_operatorsCombo.removeAllItems();
            }
            this.m_operatorsCombo.removeActionListener(this);
            this.m_operatorsCombo = null;
        }
        if (this.m_valueTextField != null) {
            this.m_valueTextField.removeActionListener(this);
            this.m_valueTextField = null;
        }
        if (this.m_logicalOpsCombo != null) {
            if (this.m_logicalOpsCombo.getItemCount() > 0) {
                this.m_logicalOpsCombo.removeAllItems();
            }
            this.m_logicalOpsCombo.removeActionListener(this);
            this.m_logicalOpsCombo = null;
        }
        if (this.m_insertButton != null) {
            this.m_insertButton.removeActionListener(this);
            this.m_insertButton = null;
        }
        if (this.m_clearButton != null) {
            this.m_clearButton.removeActionListener(this);
            this.m_clearButton = null;
        }
        if (this.m_filterStringTextArea != null) {
            this.m_filterStringTextArea.removeFocusListener(this);
            this.m_filterStringTextArea = null;
        }
        if (this.m_indexCombo != null) {
            if (this.m_indexCombo.getItemCount() > 0) {
                this.m_indexCombo.removeAllItems();
            }
            this.m_indexCombo.removeAllItems();
            this.m_indexCombo.removeActionListener(this);
            this.m_indexCombo = null;
        }
        this.m_sessionInfo = null;
        this.m_workBasketDef = null;
        this.m_queueDef = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return true;
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        try {
            this.m_queueDef = queueDef;
            this.reinitialize();
            this.m_showAllUserCheckBox.setVisible(this.m_queueDef != null && this.m_queueDef.getQueueType() == 2);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            block7: {
                try {
                    this.m_workBasketDef = workBasketDef;
                    if (this.m_workBasketDef == null) {
                        this.setEnabled(false);
                        break block7;
                    }
                    this.setEnabled(true);
                    this.reinitialize();
                    this.initFilterStringTextArea();
                    this.initSelectedIndex();
                    if (!(workBasketDef.getQueryFilterString() != null && workBasketDef.getQueryFilterString().length() != 0 || workBasketDef.getIndexName() != null && workBasketDef.getIndexName().length() != 0)) {
                        this.m_AllContentRadioButton.setSelected(true);
                        this.m_filterPanel.setVisible(false);
                        this.m_spacerPanel.setVisible(true);
                    } else {
                        this.m_useFilterRadioButton.setSelected(true);
                        this.m_filterPanel.setVisible(true);
                        this.m_spacerPanel.setVisible(false);
                    }
                    this.m_showAllUserCheckBox.setSelected(workBasketDef.isShowWorkForAllUsers());
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var4_3 = null;
                    this.m_bIsModified = false;
                }
            }
            Object var4_2 = null;
            this.m_bIsModified = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_bIsModified = false;
            throw throwable;
        }
    }

    protected boolean isModified() {
        this.handleUpdateEvent(this.m_filterStringTextArea);
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        this.m_bIsModified = false;
    }

    private void createControls() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            VWInfoLabel titleLabel = new VWInfoLabel(VWResource.InbasketContent);
            titleLabel.updateFontSize("14");
            VWAccessibilityHelper.setAccessibility(titleLabel, this, VWResource.InbasketContent, VWResource.InbasketContent);
            this.add((Component)titleLabel, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(3, 15, 1, 1);
            gbCons.gridwidth = -1;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.m_AllContentRadioButton = new JRadioButton(VWResource.AllowAllContent);
            this.m_AllContentRadioButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_AllContentRadioButton, this, VWResource.AllowAllContent, VWResource.AllowAllContent);
            buttonGroup.add(this.m_AllContentRadioButton);
            this.add((Component)this.m_AllContentRadioButton, gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(1, 15, 1, 1);
            this.m_useFilterRadioButton = new JRadioButton(VWResource.CreateAFilter);
            this.m_useFilterRadioButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_useFilterRadioButton, this, VWResource.CreateAFilter, VWResource.CreateAFilter);
            buttonGroup.add(this.m_useFilterRadioButton);
            this.add((Component)this.m_useFilterRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_showAllUserCheckBox = new JCheckBox(VWResource.ShowWorkForAllUsers);
            this.m_showAllUserCheckBox.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_showAllUserCheckBox, this, VWResource.ShowWorkForAllUsers, VWResource.ShowWorkForAllUsers);
            this.add((Component)this.m_showAllUserCheckBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.insets = new Insets(3, 0, 0, 0);
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.add((Component)this.getMainFilterPanel(), gbCons);
            ++gbCons.gridy;
            this.m_spacerPanel = new JPanel(new GridBagLayout());
            this.m_spacerPanel.add((Component)new JLabel(" "), gbCons);
            this.add((Component)this.m_spacerPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainFilterPanel() {
        try {
            this.m_filterPanel = new JPanel(new GridBagLayout());
            this.m_filterPanel.setBorder(new VWLineBorder());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 6, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            JLabel numberOneLabel = new JLabel(VWImageLoader.createImageIconNoMessage("number_1.gif"));
            VWAccessibilityHelper.setAccessibility(numberOneLabel, this, VWResource.NumberOne, VWResource.NumberOne);
            this.m_filterPanel.add((Component)numberOneLabel, gbCons);
            ++gbCons.gridx;
            this.m_filterPanel.add((Component)this.getNumberOneMessagePanel(), gbCons);
            ++gbCons.gridx;
            JLabel numberTwoLabel = new JLabel(VWImageLoader.createImageIconNoMessage("number_2.gif"));
            VWAccessibilityHelper.setAccessibility(numberTwoLabel, this, VWResource.NumberTwo, VWResource.NumberTwo);
            this.m_filterPanel.add((Component)numberTwoLabel, gbCons);
            ++gbCons.gridx;
            this.m_filterPanel.add((Component)this.getNumberTwoMessagePanel(), gbCons);
            gbCons.gridx = 1;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(3, 6, 1, 1);
            this.m_filterPanel.add((Component)this.getControlPanel(), gbCons);
            gbCons.gridx += 2;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_filterPanel.add((Component)this.getQueryFilterPanel(), gbCons);
            if (this.m_bDisplayIndexControls) {
                gbCons.gridx = 2;
                ++gbCons.gridy;
                gbCons.fill = 0;
                gbCons.weightx = 0.0;
                gbCons.weighty = 0.0;
                gbCons.insets = new Insets(6, 6, 1, 1);
                JLabel numberThreeLabel = new JLabel(VWImageLoader.createImageIconNoMessage("number_3.gif"));
                VWAccessibilityHelper.setAccessibility(numberThreeLabel, this, VWResource.NumberThree, VWResource.NumberThree);
                this.m_filterPanel.add((Component)numberThreeLabel, gbCons);
                ++gbCons.gridx;
                this.m_filterPanel.add((Component)this.getIndexPanel(), gbCons);
            }
            return this.m_filterPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getNumberOneMessagePanel() {
        try {
            JPanel messagePanel = new JPanel(new BorderLayout());
            JLabel titleLabel = new JLabel(VWResource.SelectAttributes);
            VWAccessibilityHelper.setAccessibility(titleLabel, this, VWResource.SelectAttributes, VWResource.SelectAttributes);
            messagePanel.add((Component)titleLabel, "First");
            VWInfoLabel descriptionLabel = new VWInfoLabel(VWResource.UseTheFieldsToBuildTheFilter);
            descriptionLabel.updateFontSize("10");
            VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.UseTheFieldsToBuildTheFilter, VWResource.UseTheFieldsToBuildTheFilter);
            messagePanel.add((Component)descriptionLabel, "Last");
            return messagePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getNumberTwoMessagePanel() {
        try {
            JPanel messagePanel = new JPanel(new BorderLayout());
            JLabel titleLabel = new JLabel(VWResource.CodeForFilter);
            VWAccessibilityHelper.setAccessibility(titleLabel, this, VWResource.CodeForFilter, VWResource.CodeForFilter);
            messagePanel.add((Component)titleLabel, "First");
            VWInfoLabel descriptionLabel = new VWInfoLabel(VWResource.EditTheQueryDirectly);
            descriptionLabel.updateFontSize("10");
            VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.EditTheQueryDirectly, VWResource.EditTheQueryDirectly);
            messagePanel.add((Component)descriptionLabel, "Last");
            return messagePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getControlPanel() {
        try {
            JPanel controlPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            controlPanel.add((Component)this.getSubControlPanel(), gbCons);
            gbCons.anchor = 10;
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(1, 20, 1, 1);
            this.m_insertButton = new JButton(VWResource.AddArrows);
            this.m_insertButton.setEnabled(true);
            this.m_insertButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_insertButton, this, VWResource.AddArrows, VWResource.AddArrows);
            controlPanel.add((Component)this.m_insertButton, gbCons);
            return controlPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getSubControlPanel() {
        try {
            JPanel subControlPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 6, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            subControlPanel.add((Component)new JLabel(" "), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = -1;
            this.m_leftParenButton = new JToggleButton("(");
            this.m_leftParenButton.setMargin(new Insets(0, 5, 0, 5));
            VWAccessibilityHelper.setAccessibility(this.m_leftParenButton, this, VWResource.LeftParenButton, VWResource.LeftParenButton);
            subControlPanel.add((Component)this.m_leftParenButton, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            this.m_rightParenButton = new JToggleButton(")");
            this.m_rightParenButton.setMargin(new Insets(0, 5, 0, 5));
            VWAccessibilityHelper.setAccessibility(this.m_rightParenButton, this, VWResource.RightParenButton, VWResource.RightParenButton);
            subControlPanel.add((Component)this.m_rightParenButton, gbCons);
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(3, 1, 1, 1);
            this.m_fieldsCombo = new JComboBox();
            this.m_fieldsCombo.setRenderer(new VWFieldListRenderer());
            this.m_fieldsCombo.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_fieldsCombo, this, VWResource.s_searchFieldsComboBox, VWResource.s_searchFieldsComboBox);
            subControlPanel.add((Component)this.m_fieldsCombo, gbCons);
            ++gbCons.gridy;
            this.m_operatorsCombo = new JComboBox();
            this.m_operatorsCombo.addActionListener(this);
            this.m_operatorsCombo.setRenderer(new VWOperatorComboBoxRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_operatorsCombo, this, VWResource.s_operatorsComboBox, VWResource.s_operatorsComboBox);
            subControlPanel.add((Component)this.m_operatorsCombo, gbCons);
            ++gbCons.gridy;
            this.m_valueTextField = new JTextField();
            this.m_enabledBkgrndColor = this.m_valueTextField.getBackground();
            this.m_valueTextField.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_valueTextField, this, VWResource.s_valueTextField, VWResource.s_valueTextField);
            subControlPanel.add((Component)this.m_valueTextField, gbCons);
            ++gbCons.gridy;
            String[] logicalOperators = new String[]{VWResource.s_none, VWResource.s_and, VWResource.s_or};
            this.m_logicalOpsCombo = new JComboBox<String>(logicalOperators);
            this.m_logicalOpsCombo.setRenderer(new VWLabelListCellRenderer());
            VWAccessibilityHelper.setAccessibility(this.m_operatorsCombo, this, VWResource.LogicalOperatorsComboBox, VWResource.LogicalOperatorsComboBox);
            subControlPanel.add((Component)this.m_logicalOpsCombo, gbCons);
            return subControlPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getQueryFilterPanel() {
        try {
            JPanel queryFilterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 22;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            this.m_clearButton = new JButton(VWResource.s_clear);
            this.m_clearButton.setMargin(new Insets(0, 5, 0, 5));
            this.m_clearButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_clearButton, this, VWResource.s_clear, VWResource.s_clear);
            queryFilterPanel.add((Component)this.m_clearButton, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(3, 1, 1, 1);
            this.m_filterStringTextArea = new JTextArea();
            this.m_filterStringTextArea.setLineWrap(true);
            this.m_filterStringTextArea.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_filterStringTextArea, this, VWResource.s_filterTextArea, VWResource.s_filterTextArea);
            queryFilterPanel.add((Component)new JScrollPane(this.m_filterStringTextArea), gbCons);
            return queryFilterPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getIndexPanel() {
        try {
            JPanel indexPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 1, 1, 1);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            VWInfoLabel selectIndexLabel = new VWInfoLabel(VWResource.SelectIndex);
            selectIndexLabel.updateFontSize("10");
            VWAccessibilityHelper.setAccessibility(selectIndexLabel, this, VWResource.SelectIndex, VWResource.SelectIndex);
            indexPanel.add((Component)selectIndexLabel, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_indexCombo = new JComboBox();
            VWAccessibilityHelper.setAccessibility(this.m_indexCombo, this, VWResource.s_indexComboBox, VWResource.s_indexComboBox);
            VWAccessibilityHelper.setLabelFor(selectIndexLabel, this.m_indexCombo);
            this.m_indexCombo.setRenderer(new VWIndexListRenderer());
            this.m_indexCombo.addActionListener(this);
            indexPanel.add((Component)this.m_indexCombo, gbCons);
            return indexPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleUpdateEvent(Object source) {
        if (source == null) {
            return;
        }
        if (this.m_workBasketDef == null) {
            return;
        }
        if (source.equals(this.m_insertButton) || source.equals(this.m_valueTextField) || source.equals(this.m_filterStringTextArea)) {
            try {
                if (VWStringUtils.compare(this.m_filterStringTextArea.getText(), this.m_workBasketDef.getQueryFilterString()) != 0) {
                    this.m_workBasketDef.setQueryFilterString(this.m_filterStringTextArea.getText());
                    this.m_bIsModified = true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
                this.m_filterStringTextArea.selectAll();
            }
        } else if (source.equals(this.m_indexCombo)) {
            try {
                if (this.m_indexCombo == null) {
                    return;
                }
                boolean bChanged = false;
                Object selectedItem = this.m_indexCombo.getSelectedItem();
                if (selectedItem == null || !(selectedItem instanceof VWIndexDefinition)) {
                    return;
                }
                String newIndexName = ((VWIndexDefinition)selectedItem).getAuthoredName();
                if (newIndexName == null) {
                    return;
                }
                String currentIndexName = this.m_workBasketDef.getIndexName();
                if (newIndexName.compareTo(VWResource.s_default) == 0) {
                    newIndexName = null;
                    if (currentIndexName != null) {
                        bChanged = true;
                    }
                } else if (currentIndexName == null || currentIndexName.compareTo(newIndexName) != 0) {
                    bChanged = true;
                }
                if (bChanged) {
                    this.m_workBasketDef.setIndexName(newIndexName);
                    this.m_bIsModified = true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    private void resetFilterControls() {
        try {
            this.m_leftParenButton.setSelected(false);
            this.m_rightParenButton.setSelected(false);
            if (this.m_fieldsCombo.getItemCount() > 0) {
                this.m_fieldsCombo.setSelectedIndex(0);
            }
            this.m_valueTextField.setText("");
            if (this.m_logicalOpsCombo.getItemCount() > 0) {
                this.m_logicalOpsCombo.setSelectedIndex(0);
            }
            this.m_filterStringTextArea.setText("");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void reinitialize() {
        this.initFieldsComboBox();
        this.initOperatorsCombo();
        this.m_valueTextField.setText("");
        this.m_filterStringTextArea.setText("");
        this.initIndexComboBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initFieldsComboBox() {
        try {
            try {
                if (this.m_queueDef == null) {
                    Object var5_1 = null;
                    if (this.m_fieldsCombo.getItemCount() > 0) {
                        this.m_fieldsCombo.setSelectedIndex(0);
                    }
                    this.m_fieldsCombo.addActionListener(this);
                    return;
                }
                ActionListener[] l = this.m_fieldsCombo.getActionListeners();
                for (int i = 0; i < l.length; ++i) {
                    this.m_fieldsCombo.removeActionListener(l[i]);
                }
                Object[] fieldDefs = this.m_queueDef.getFields();
                VWQubbleSort.sort(fieldDefs);
                DefaultComboBoxModel<Object> dataModel = new DefaultComboBoxModel<Object>(fieldDefs);
                this.m_fieldsCombo.setModel(dataModel);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_3 = null;
                if (this.m_fieldsCombo.getItemCount() > 0) {
                    this.m_fieldsCombo.setSelectedIndex(0);
                }
                this.m_fieldsCombo.addActionListener(this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.m_fieldsCombo.getItemCount() > 0) {
                this.m_fieldsCombo.setSelectedIndex(0);
            }
            this.m_fieldsCombo.addActionListener(this);
            throw throwable;
        }
        Object var5_2 = null;
        if (this.m_fieldsCombo.getItemCount() > 0) {
            this.m_fieldsCombo.setSelectedIndex(0);
        }
        this.m_fieldsCombo.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initOperatorsCombo() {
        try {
            try {
                ActionListener[] listeners = this.m_operatorsCombo.getActionListeners();
                for (int nIndex = 0; nIndex < listeners.length; ++nIndex) {
                    this.m_operatorsCombo.removeActionListener(listeners[nIndex]);
                }
                this.m_operatorsCombo.removeAllItems();
                VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_fieldsCombo.getSelectedItem();
                if (fieldDef == null) {
                    Object var5_5 = null;
                    if (this.m_operatorsCombo.getItemCount() > 0) {
                        this.m_operatorsCombo.setSelectedIndex(0);
                    }
                    this.m_operatorsCombo.addActionListener(this);
                    return;
                }
                DefaultComboBoxModel cbModel = VWOperatorComboBoxRenderer.getComboBoxModel(fieldDef.getFieldType(), true);
                if (cbModel != null) {
                    this.m_operatorsCombo.setModel(cbModel);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_7 = null;
                if (this.m_operatorsCombo.getItemCount() > 0) {
                    this.m_operatorsCombo.setSelectedIndex(0);
                }
                this.m_operatorsCombo.addActionListener(this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (this.m_operatorsCombo.getItemCount() > 0) {
                this.m_operatorsCombo.setSelectedIndex(0);
            }
            this.m_operatorsCombo.addActionListener(this);
            throw throwable;
        }
        Object var5_6 = null;
        if (this.m_operatorsCombo.getItemCount() > 0) {
            this.m_operatorsCombo.setSelectedIndex(0);
        }
        this.m_operatorsCombo.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexComboBox() {
        if (this.m_queueDef == null || this.m_indexCombo == null) {
            return;
        }
        try {
            try {
                Object[] indexDefs;
                ActionListener[] l = this.m_indexCombo.getActionListeners();
                for (int i = 0; i < l.length; ++i) {
                    this.m_indexCombo.removeActionListener(l[i]);
                }
                DefaultComboBoxModel dataModel = (DefaultComboBoxModel)this.m_indexCombo.getModel();
                if (dataModel.getSize() > 0) {
                    dataModel.removeAllElements();
                }
                dataModel.addElement(VWResource.s_default);
                if (this.m_queueDef != null && (indexDefs = this.m_queueDef.getIndexes()) != null) {
                    VWQubbleSort.sort(indexDefs);
                    for (int i = 0; i < indexDefs.length; ++i) {
                        dataModel.addElement(indexDefs[i]);
                    }
                }
                Object var6_7 = null;
                this.m_indexCombo.setSelectedIndex(0);
                this.m_indexCombo.addActionListener(this);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var6_8 = null;
                this.m_indexCombo.setSelectedIndex(0);
                this.m_indexCombo.addActionListener(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.m_indexCombo.setSelectedIndex(0);
            this.m_indexCombo.addActionListener(this);
            throw throwable;
        }
    }

    private void initFilterStringTextArea() {
        try {
            if (this.m_workBasketDef != null && this.m_filterStringTextArea != null) {
                this.m_filterStringTextArea.setText(this.m_workBasketDef.getQueryFilterString());
                this.m_filterStringTextArea.setCaretPosition(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSelectedIndex() throws Exception {
        block9: {
            if (this.m_workBasketDef == null) return;
            if (this.m_indexCombo == null) {
                return;
            }
            try {
                try {
                    ActionListener[] l = this.m_indexCombo.getActionListeners();
                    for (int i = 0; i < l.length; ++i) {
                        this.m_indexCombo.removeActionListener(l[i]);
                    }
                    String currentIndexName = this.m_workBasketDef.getIndexName();
                    if (currentIndexName == null || currentIndexName.compareTo("") == 0 || currentIndexName.compareTo(VWResource.s_default) == 0) {
                        this.m_indexCombo.setSelectedIndex(0);
                        Object var6_5 = null;
                        this.m_indexCombo.addActionListener(this);
                        return;
                    }
                    int i = 0;
                    while (i < this.m_indexCombo.getItemCount()) {
                        String indexName = this.m_indexCombo.getItemAt(i).toString();
                        if (currentIndexName.compareTo(indexName) == 0) {
                            this.m_indexCombo.setSelectedIndex(i);
                            break block9;
                        }
                        ++i;
                    }
                    throw new VWException("vw.toolkit.admin.property.queue.indexNotMatched", "Cannot find a match of index in the VWWorkBasketDefinition");
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var6_7 = null;
                    this.m_indexCombo.addActionListener(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.m_indexCombo.addActionListener(this);
                throw throwable;
            }
        }
        Object var6_6 = null;
        this.m_indexCombo.addActionListener(this);
    }

    private void updateFilterString() {
        try {
            VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_fieldsCombo.getSelectedItem();
            if (fieldDef == null) {
                return;
            }
            String value = this.m_valueTextField.getText();
            if ((value == null || value.length() == 0) && fieldDef.getFieldType() != 2) {
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_invalidValue, 2);
                return;
            }
            switch (fieldDef.getFieldType()) {
                case 16: {
                    Date aDate = this.convertToDate(value);
                    if (aDate != null) {
                        long lValue = aDate.getTime() / 1000L;
                        Long LValue = lValue;
                        this.appendToFilterString(LValue.toString());
                    }
                    break;
                }
                case 1: {
                    try {
                        new Integer(value);
                        this.appendToFilterString(value);
                    }
                    catch (NumberFormatException ex) {
                        VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_invalidIntegerFormat, 2);
                    }
                    break;
                }
                case 8: {
                    try {
                        Double newFloatValue = new Double(value);
                        this.appendToFilterString(newFloatValue.toString());
                    }
                    catch (NumberFormatException ex) {
                        VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_invalidFloatFormat, 2);
                    }
                    break;
                }
                case 2: {
                    int op = (Integer)this.m_operatorsCombo.getSelectedItem();
                    if (op == 8 || op == 9) {
                        this.appendToFilterString(null);
                        return;
                    }
                    String sValue = this.m_valueTextField.getText();
                    if (sValue != null && sValue.length() > 0) {
                        if (!sValue.startsWith("'")) {
                            sValue = "'" + sValue;
                        }
                        if (!sValue.endsWith("'")) {
                            sValue = sValue + "'";
                        }
                        int nIndex = 0;
                        int startIndex = 0;
                        while ((nIndex = sValue.indexOf("'", startIndex)) != -1) {
                            if (nIndex != 0 && nIndex != sValue.length() - 1) {
                                String smallString = sValue.substring(0, nIndex);
                                String anotherString = sValue.substring(nIndex, sValue.length());
                                sValue = smallString + "'" + anotherString;
                                startIndex = nIndex + 2;
                                continue;
                            }
                            if (nIndex == sValue.length() - 1) break;
                            ++startIndex;
                        }
                        this.appendToFilterString(sValue);
                        break;
                    }
                    this.appendToFilterString("''");
                    break;
                }
                case 4: {
                    if (VWStringUtils.compareIgnoreCase(value, VWResource.s_true) == 0 || VWStringUtils.compareIgnoreCase(value, "1") == 0) {
                        this.appendToFilterString("1");
                        break;
                    }
                    if (VWStringUtils.compareIgnoreCase(value, VWResource.s_false) == 0 || VWStringUtils.compareIgnoreCase(value, "0") == 0) {
                        this.appendToFilterString("0");
                        break;
                    }
                    VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), VWResource.s_invalidBooleanFormat, 2);
                    break;
                }
                default: {
                    this.appendToFilterString(this.m_valueTextField.getText());
                    break;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private Date convertToDate(String aString) {
        Date date = null;
        if (aString != null && aString.length() > 0) {
            int nCount = VWFieldsCellEditor.s_dateTimeFormatters.length;
            for (int i = 0; i < nCount; ++i) {
                try {
                    date = VWFieldsCellEditor.s_dateTimeFormatters[i].parse(aString);
                    if (date == null) continue;
                    break;
                }
                catch (ParseException ex) {
                    if (i != nCount - 1) continue;
                    VWDateTimeErrDialog errDlg = new VWDateTimeErrDialog(null, VWResource.s_error, VWResource.s_invalidDateTimeFormat, 0);
                    errDlg.setVisible(true);
                    date = null;
                }
            }
        }
        return date;
    }

    private void appendToFilterString(String value) throws VWException {
        VWExposedFieldDefinition fieldDef = (VWExposedFieldDefinition)this.m_fieldsCombo.getSelectedItem();
        if (fieldDef == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.m_leftParenButton.isSelected()) {
            buffer.append("(");
        }
        buffer.append(fieldDef.getAuthoredName() + " ");
        Integer item = (Integer)this.m_operatorsCombo.getSelectedItem();
        if (item != null) {
            int iOp = item;
            buffer.append(VWOperatorComboBoxRenderer.convertToSQLOperator(iOp) + " ");
        }
        if (value != null) {
            buffer.append(value);
        }
        if (this.m_rightParenButton.isSelected()) {
            buffer.append(")");
        }
        String logicalString = (String)this.m_logicalOpsCombo.getSelectedItem();
        if (item != null) {
            if (VWStringUtils.compare(logicalString, VWResource.s_and) == 0) {
                buffer.append(" and ");
            } else if (VWStringUtils.compare(logicalString, VWResource.s_or) == 0) {
                buffer.append(" or ");
            }
        }
        this.m_filterStringTextArea.append(buffer.toString());
    }
}

